<?php defined('BASEPATH') || exit('No direct script access allowed.');

/**
* Answers Model
*/
class Answers_Model extends CI_Model
{
	public $table = 'answers';
	
	function __construct()
	{
		parent::__construct();
	}

	public function insert($question_id)
	{
		$data = array();

		foreach ($this->input->post('answers_en') as $key=>$answer) {
			if($answer !=''){
				$data[$key]['answer_content_en'] = $answer;
			}
		}
		foreach ($this->input->post('answers_hin') as $key=>$answer) {
			if($answer !=''){
				$data[$key]['answer_content_hin'] = $answer;
			}	
		}

		foreach($data as $key=>$row){
			$data[$key]['question_ID'] = $question_id;
			if($key+1 == $this->input->post('correct_answer')) {
				$data[$key]['correct_answer'] = 1;
			} else {
				$data[$key]['correct_answer'] = 0;
			}

			if(!array_key_exists('answer_content_en',$data[$key]) ){
				$data[$key]['answer_content_en'] = '';
			}

			if(!array_key_exists('answer_content_hin',$data[$key]) ){
				$data[$key]['answer_content_hin'] = '';
			}
		}

		$this->db->trans_start();
		foreach($data as $row){
			$this->db->insert($this->table,$row);
		}
		$this->db->trans_complete();

		return ($this->db->trans_status()==TRUE)? $this->db->trans_status():FALSE;
	}

	public function get()
	{
		$query = $this->db->get($this->table);
		return $query->result();
	}

	public function get_answers_of_question($question_id)
	{
		$query = $this->db->get_where($this->table,array('question_ID'=>$question_id));
		return $query->result();
	}

	public function update()
	{
		if($this->db->delete( $this->table, array('question_ID' => $this->input->post('question_id') ) )){
			return $this->insert( $this->input->post('question_id') );
		} else {
			return false;
		}
	}

	public function delete($question_id)
	{
		return $this->db->delete($this->table, array('question_ID'=>$question_id));
	}
}